CONTAINER Ocacluster
{
	NAME Ocacluster;
	INCLUDE Obase;
	
	GROUP ID_OBJECTPROPERTIES
	{
		LINK ID_CA_CLUSTER_OBJECT_LINK { ACCEPT { Obase; Tbase; } }
		GROUP
		{
			COLUMNS 2;
			
			LINK ID_CA_CLUSTER_OBJECT_TARGET { ACCEPT { Obase; } }
			BUTTON ID_CA_CLUSTER_OBJECT_TARGET_ADD { }
		}
		
		REAL ID_CA_CLUSTER_OBJECT_STRENGTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		
		GROUP
		{
			COLUMNS 2;
			
			LONG ID_CA_CLUSTER_OBJECT_TRANSFORM
			{
				SCALE_H;
				
				CYCLE
				{
					ID_CA_CLUSTER_OBJECT_TRANSFORM_LOCAL;
					ID_CA_CLUSTER_OBJECT_TRANSFORM_WORLD;
				}
			}
				
			LONG ID_CA_CLUSTER_OBJECT_MATRIX
			{
				SCALE_H;
			
				CYCLE
				{
					ID_CA_CLUSTER_OBJECT_MATRIX_OBJECT;
					ID_CA_CLUSTER_OBJECT_MATRIX_POINT_CENTER;
					ID_CA_CLUSTER_OBJECT_MATRIX_POINT_ALIGN;
				}
			}
						
			LONG ID_CA_CLUSTER_OBJECT_ALIGN_AXIS
			{
				SCALE_H;
			
				CYCLE
				{
					ID_CA_CLUSTER_OBJECT_ALIGN_AXIS_X;
					ID_CA_CLUSTER_OBJECT_ALIGN_AXIS_Y;
					ID_CA_CLUSTER_OBJECT_ALIGN_AXIS_Z;
				}
			}
			STATICTEXT { NEWLINE; }
			
			LONG ID_CA_CLUSTER_FALLOFF_MODE
			{
				SCALE_H; 
				
				CYCLE
				{
					ID_CA_CLUSTER_FALLOFF_MODE_NONE;
					ID_CA_CLUSTER_FALLOFF_MODE_WORLD;
					ID_CA_CLUSTER_FALLOFF_MODE_LOCAL;
					ID_CA_CLUSTER_FALLOFF_MODE_SURFACE;
				}
			}
			
			LONG ID_CA_CLUSTER_FALLOFF
			{
				SCALE_H; 

				CYCLE
				{
					ID_CA_CLUSTER_FALLOFF_SIMPLE;
					ID_CA_CLUSTER_FALLOFF_LINEAR;
					ID_CA_CLUSTER_FALLOFF_DOME;
					ID_CA_CLUSTER_FALLOFF_BELL;
					ID_CA_CLUSTER_FALLOFF_CIRCLE;
					ID_CA_CLUSTER_FALLOFF_NEEDLE;
					ID_CA_CLUSTER_FALLOFF_SPLINE;
				}
			}
			
			REAL ID_CA_CLUSTER_FALLOFF_RADIUS { UNIT METER; MIN 0.0; MAXSLIDER 100.0; SCALE_H; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINENDSCALE; }
			
			REAL ID_CA_CLUSTER_WIDTH { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINENDSCALE; }
			
			REAL ID_CA_CLUSTER_HARDNESS { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
			STATICTEXT { JOINENDSCALE; }

			SPLINE ID_CA_CLUSTER_FALLOFF_CURVE {  }
			STATICTEXT { JOINENDSCALE; }
		}
		
		GROUP ID_CA_CLUSTER_OBJECT_OFFSET_GROUP
		{
			BOOL ID_CA_CLUSTER_OBJECT_MAINTAIN_OFFSET { }
			
			GROUP
			{
				LAYOUTGROUP; COLUMNS 3;

				GROUP { VECTOR ID_CA_CLUSTER_OBJECT_MAINTAIN_P_OFFSET { UNIT METER; CUSTOMGUI SUBDESCRIPTION; } }
				GROUP { VECTOR ID_CA_CLUSTER_OBJECT_MAINTAIN_S_OFFSET { STEP 0.01; CUSTOMGUI SUBDESCRIPTION; } }
				GROUP { VECTOR ID_CA_CLUSTER_OBJECT_MAINTAIN_R_OFFSET { UNIT DEGREE; CUSTOMGUI SUBDESCRIPTION; } }
			}
		}
	}

	GROUP ID_CA_CLUSTER_OBJECT_WEIGHT_GROUP
	{
		COLUMNS 2; SCALE_V;
		
		REAL ID_CA_CLUSTER_OBJECT_P_WEIGHT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		LINK ID_CA_CLUSTER_OBJECT_P_WEIGHT_MAP { ACCEPT { Tbase; } }
		
		REAL ID_CA_CLUSTER_OBJECT_S_WEIGHT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		LINK ID_CA_CLUSTER_OBJECT_S_WEIGHT_MAP { ACCEPT { Tbase; } }
		
		REAL ID_CA_CLUSTER_OBJECT_R_WEIGHT { UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		LINK ID_CA_CLUSTER_OBJECT_R_WEIGHT_MAP { ACCEPT { Tbase; } }

		IN_EXCLUDE  ID_CA_CLUSTER_EFFECTOR
		{
			NUM_FLAGS 0; INIT_STATE 1; SEND_SELCHNGMSG 1; SCALE_V;
			ACCEPT { 1019677; };
		}
		STATICTEXT { JOINENDSCALE; }
	}
}
